/* -LICENSE-START-
 ** Copyright (c) 2015 Blackmagic Design
 **
 ** Permission is hereby granted, free of charge, to any person or organization
 ** obtaining a copy of the software and accompanying documentation covered by
 ** this license (the "Software") to use, reproduce, display, distribute,
 ** execute, and transmit the Software, and to prepare derivative works of the
 ** Software, and to permit third-parties to whom the Software is furnished to
 ** do so, all subject to the following:
 **
 ** The copyright notices in the Software and this entire statement, including
 ** the above license grant, this restriction and the following disclaimer,
 ** must be included in all copies of the Software, in whole or in part, and
 ** all derivative works of the Software, unless such copies or derivative
 ** works are solely in the form of machine-executable object code generated by
 ** a source language processor.
 **
 ** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 ** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 ** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 ** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
 ** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 ** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 ** DEALINGS IN THE SOFTWARE.
 ** -LICENSE-END-
 */
#pragma once

#include <QFrame>
#include <QSlider>
#include <QLabel>
#include <QAbstractButton>
#include <QTime>

#include <array>
#include <stdint.h>

class QTimer;
class FlatImageButton;

class TimeCodeLabel : public QWidget
{
	Q_OBJECT

public:
	TimeCodeLabel();

	void setTime(int ms, uint32_t frameRate);

private:

	std::array<QLabel*, 8> m_labels;
};

class ControlsWidget : public QFrame
{
	Q_OBJECT

public:
	ControlsWidget();

	FlatImageButton* m_recordButton;
	QSlider* m_speedSlider;

	void onRecordingStarted(QString, uint32_t);
	void onRecordingStopped();

signals:
	void speedChanged(int bitrate);

private slots:
	void onSpeedChanged(int value);
	void onUpdateTime();

private:
	static const int kSpeedStepSize = 500000; // bits

	void updateTimeLabel(int ms);

	QLabel* m_speedLabel;
	TimeCodeLabel* m_tcLabel;
	QLabel* m_modeLabel;

	QTime m_recordTime;
	int m_recordedDurationMs;
	QTimer* m_updateTimer;

	uint32_t m_frameRate;
};


